<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" data-theme="professional">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="theme-color" content="#dc2626">
    
    <title><?php echo e($seo['title'] ?? config('app.name')); ?></title>
    <meta name="description" content="<?php echo e($seo['description'] ?? ''); ?>">
    <meta name="keywords" content="<?php echo e($seo['keywords'] ?? ''); ?>">
    <meta name="author" content="<?php echo e(config('app.name')); ?>">
    <link rel="canonical" href="<?php echo e($seo['canonical'] ?? url()->current()); ?>">
    
    <meta property="og:title" content="<?php echo e($seo['og_title'] ?? $seo['title'] ?? ''); ?>">
    <meta property="og:description" content="<?php echo e($seo['og_description'] ?? $seo['description'] ?? ''); ?>">
    <meta property="og:image" content="<?php echo e($seo['og_image'] ?? ''); ?>">
    <meta property="og:url" content="<?php echo e($seo['og_url'] ?? url()->current()); ?>">
    <meta property="og:type" content="website">
    <meta property="og:site_name" content="<?php echo e(config('app.name')); ?>">
    <meta property="og:locale" content="en_US">
    
    <meta name="twitter:card" content="<?php echo e($seo['twitter_card'] ?? 'summary_large_image'); ?>">
    <meta name="twitter:title" content="<?php echo e($seo['og_title'] ?? $seo['title'] ?? ''); ?>">
    <meta name="twitter:description" content="<?php echo e($seo['og_description'] ?? $seo['description'] ?? ''); ?>">
    <meta name="twitter:image" content="<?php echo e($seo['og_image'] ?? ''); ?>">
    <meta name="twitter:site" content="@agency">
    
    <meta name="robots" content="index, follow, max-snippet:-1, max-image-preview:large, max-video-preview:-1">
    <meta name="googlebot" content="index, follow">
    <meta name="bingbot" content="index, follow">
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <link rel="dns-prefetch" href="https://fonts.googleapis.com">
    <link rel="manifest" href="/manifest.json">
    
    <?php echo $__env->yieldPushContent('schema'); ?>
    
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    
    <link rel="alternate" hreflang="en" href="<?php echo e(url()->current()); ?>">
    <link rel="alternate" hreflang="x-default" href="<?php echo e(url()->current()); ?>">
</head>
<body class="antialiased">
    <nav class="bg-white/95 backdrop-blur-md shadow-sm sticky top-0 z-50 border-b border-gray-100" role="navigation" aria-label="Main navigation">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between h-16 md:h-20">
                <!-- Logo -->
                <div class="flex-shrink-0">
                    <a href="/" class="flex items-center space-x-2 group" aria-label="Agency Home">
                        <div class="w-10 h-10 bg-red-600 rounded-lg flex items-center justify-center transform group-hover:scale-110 transition-transform">
                            <span class="text-white font-black text-xl">R</span>
                        </div>
                        <div class="hidden sm:block">
                            <span class="text-2xl font-black text-red-600">REDX</span>
                            <span class="text-xs text-gray-500 block -mt-1 font-medium">Studios</span>
                        </div>
                    </a>
                </div>
                
                <!-- Desktop Menu -->
                <div class="hidden md:flex items-center space-x-8">
                    <a href="/" class="text-gray-700 hover:text-red-600 font-semibold transition-colors" aria-label="Home page">Home</a>
                    <a href="/services" class="text-gray-700 hover:text-red-600 font-semibold transition-colors" aria-label="Our services">Services</a>
                    <a href="#contact" class="px-6 py-2.5 bg-red-600 text-white font-bold rounded-full hover:bg-red-700 transition-all hover:shadow-lg hover:shadow-red-600/30 hover:scale-105" aria-label="Contact us">Contact Us</a>
                </div>
                
                <!-- Mobile Menu Button -->
                <div class="md:hidden">
                    <button type="button" class="mobile-menu-button inline-flex items-center justify-center p-2 rounded-lg text-gray-700 hover:text-red-600 hover:bg-gray-100 transition-colors" aria-label="Toggle menu">
                        <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path class="menu-icon" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                            <path class="close-icon hidden" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </button>
                </div>
            </div>
        </div>
        
        <!-- Mobile Menu -->
        <div class="mobile-menu hidden md:hidden border-t border-gray-100">
            <div class="px-4 pt-2 pb-4 space-y-2">
                <a href="/" class="block px-4 py-3 rounded-lg text-gray-700 hover:bg-red-50 hover:text-red-600 font-semibold transition-colors" aria-label="Home page">Home</a>
                <a href="/services" class="block px-4 py-3 rounded-lg text-gray-700 hover:bg-red-50 hover:text-red-600 font-semibold transition-colors" aria-label="Our services">Services</a>
                <a href="#contact" class="block px-4 py-3 bg-red-600 text-white text-center font-bold rounded-lg hover:bg-red-700 transition-colors" aria-label="Contact us">Contact Us</a>
            </div>
        </div>
    </nav>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const menuButton = document.querySelector('.mobile-menu-button');
            const mobileMenu = document.querySelector('.mobile-menu');
            const menuIcon = document.querySelector('.menu-icon');
            const closeIcon = document.querySelector('.close-icon');
            
            menuButton.addEventListener('click', function() {
                mobileMenu.classList.toggle('hidden');
                menuIcon.classList.toggle('hidden');
                closeIcon.classList.toggle('hidden');
            });
        });
    </script>

    <main>
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <footer class="bg-gray-900 text-gray-300" role="contentinfo">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8 py-12 sm:py-16">
            <!-- Main Footer Content -->
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-8 sm:gap-12 mb-12">
                <!-- Company Info -->
                <div class="space-y-4">
                    <div class="flex items-center space-x-2">
                        <div class="w-10 h-10 bg-red-600 rounded-lg flex items-center justify-center">
                            <span class="text-white font-black text-xl">R</span>
                        </div>
                        <div>
                            <span class="text-xl font-black text-white">REDX</span>
                            <span class="text-xs text-gray-400 block -mt-1">Studios</span>
                        </div>
                    </div>
                    <p class="text-sm text-gray-400 leading-relaxed">Building exceptional digital experiences that transform businesses and drive results.</p>
                    <div class="flex space-x-4">
                        <a href="#" class="w-10 h-10 bg-gray-800 hover:bg-red-600 rounded-lg flex items-center justify-center transition-colors" aria-label="Twitter">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M8.29 20.251c7.547 0 11.675-6.253 11.675-11.675 0-.178 0-.355-.012-.53A8.348 8.348 0 0022 5.92a8.19 8.19 0 01-2.357.646 4.118 4.118 0 001.804-2.27 8.224 8.224 0 01-2.605.996 4.107 4.107 0 00-6.993 3.743 11.65 11.65 0 01-8.457-4.287 4.106 4.106 0 001.27 5.477A4.072 4.072 0 012.8 9.713v.052a4.105 4.105 0 003.292 4.022 4.095 4.095 0 01-1.853.07 4.108 4.108 0 003.834 2.85A8.233 8.233 0 012 18.407a11.616 11.616 0 006.29 1.84"></path></svg>
                        </a>
                        <a href="#" class="w-10 h-10 bg-gray-800 hover:bg-red-600 rounded-lg flex items-center justify-center transition-colors" aria-label="LinkedIn">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M20.447 20.452h-3.554v-5.569c0-1.328-.027-3.037-1.852-3.037-1.853 0-2.136 1.445-2.136 2.939v5.667H9.351V9h3.414v1.561h.046c.477-.9 1.637-1.85 3.37-1.85 3.601 0 4.267 2.37 4.267 5.455v6.286zM5.337 7.433c-1.144 0-2.063-.926-2.063-2.065 0-1.138.92-2.063 2.063-2.063 1.14 0 2.064.925 2.064 2.063 0 1.139-.925 2.065-2.064 2.065zm1.782 13.019H3.555V9h3.564v11.452zM22.225 0H1.771C.792 0 0 .774 0 1.729v20.542C0 23.227.792 24 1.771 24h20.451C23.2 24 24 23.227 24 22.271V1.729C24 .774 23.2 0 22.222 0h.003z"></path></svg>
                        </a>
                        <a href="#" class="w-10 h-10 bg-gray-800 hover:bg-red-600 rounded-lg flex items-center justify-center transition-colors" aria-label="GitHub">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M12 0c-6.626 0-12 5.373-12 12 0 5.302 3.438 9.8 8.207 11.387.599.111.793-.261.793-.577v-2.234c-3.338.726-4.033-1.416-4.033-1.416-.546-1.387-1.333-1.756-1.333-1.756-1.089-.745.083-.729.083-.729 1.205.084 1.839 1.237 1.839 1.237 1.07 1.834 2.807 1.304 3.492.997.107-.775.418-1.305.762-1.604-2.665-.305-5.467-1.334-5.467-5.931 0-1.311.469-2.381 1.236-3.221-.124-.303-.535-1.524.117-3.176 0 0 1.008-.322 3.301 1.23.957-.266 1.983-.399 3.003-.404 1.02.005 2.047.138 3.006.404 2.291-1.552 3.297-1.23 3.297-1.23.653 1.653.242 2.874.118 3.176.77.84 1.235 1.911 1.235 3.221 0 4.609-2.807 5.624-5.479 5.921.43.372.823 1.102.823 2.222v3.293c0 .319.192.694.801.576 4.765-1.589 8.199-6.086 8.199-11.386 0-6.627-5.373-12-12-12z"></path></svg>
                        </a>
                    </div>
                </div>
                
                <!-- Quick Links -->
                <div>
                    <h3 class="text-white font-bold text-lg mb-4">Quick Links</h3>
                    <ul class="space-y-3">
                        <li><a href="/" class="text-sm hover:text-red-500 transition-colors">Home</a></li>
                        <li><a href="/services" class="text-sm hover:text-red-500 transition-colors">Services</a></li>
                        <li><a href="#contact" class="text-sm hover:text-red-500 transition-colors">Contact</a></li>
                        <li><a href="/sitemap.xml" class="text-sm hover:text-red-500 transition-colors">Sitemap</a></li>
                    </ul>
                </div>
                
                <!-- Services -->
                <div>
                    <h3 class="text-white font-bold text-lg mb-4">Services</h3>
                    <ul class="space-y-3">
                        <li><a href="/services" class="text-sm hover:text-red-500 transition-colors">Web Design</a></li>
                        <li><a href="/services" class="text-sm hover:text-red-500 transition-colors">Web Development</a></li>
                        <li><a href="/services" class="text-sm hover:text-red-500 transition-colors">Mobile Apps</a></li>
                        <li><a href="/services" class="text-sm hover:text-red-500 transition-colors">SEO Optimization</a></li>
                    </ul>
                </div>
                
                <!-- Contact Info -->
                <div>
                    <h3 class="text-white font-bold text-lg mb-4">Contact</h3>
                    <ul class="space-y-3 text-sm">
                        <li class="flex items-start space-x-3">
                            <svg class="w-5 h-5 text-red-600 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path></svg>
                            <span>hello@redxstudios.com</span>
                        </li>
                        <li class="flex items-start space-x-3">
                            <svg class="w-5 h-5 text-red-600 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path></svg>
                            <span>+1 (555) 123-4567</span>
                        </li>
                        <li class="flex items-start space-x-3">
                            <svg class="w-5 h-5 text-red-600 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"></path><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"></path></svg>
                            <span>San Francisco, CA</span>
                        </li>
                    </ul>
                </div>
            </div>
            
            <!-- Bottom Bar -->
            <div class="border-t border-gray-800 pt-8">
                <div class="flex flex-col sm:flex-row justify-between items-center space-y-4 sm:space-y-0">
                    <p class="text-sm text-gray-500 text-center sm:text-left">
                        © <?php echo e(date('Y')); ?> <span class="text-white font-semibold">REDX Studios</span>. All rights reserved. Professional Web Development Agency.
                    </p>
                    <div class="flex space-x-6 text-sm">
                        <a href="#" class="text-gray-500 hover:text-red-500 transition-colors">Privacy Policy</a>
                        <a href="#" class="text-gray-500 hover:text-red-500 transition-colors">Terms of Service</a>
                    </div>
                </div>
            </div>
        </div>
    </footer>
</body>
</html>
<?php /**PATH /home/redx/redxstudios/agency-website/resources/views/layouts/app.blade.php ENDPATH**/ ?>