<?php

namespace App\Http\Controllers;

use App\Helpers\SeoHelper;

class ServiceController extends Controller
{
    private $services = [
        'web-design' => [
            'title' => 'Web Design Services',
            'description' => 'Create stunning, user-friendly websites that convert visitors into customers',
            'icon' => '🎨',
            'features' => ['Responsive Design', 'UI/UX Optimization', 'Brand Identity', 'Prototyping'],
        ],
        'web-development' => [
            'title' => 'Web Development',
            'description' => 'Build robust, scalable web applications with cutting-edge technologies',
            'icon' => '💻',
            'features' => ['Custom Development', 'API Integration', 'Database Design', 'Performance Optimization'],
        ],
        'mobile-apps' => [
            'title' => 'Mobile App Development',
            'description' => 'Native and cross-platform mobile applications for iOS and Android',
            'icon' => '📱',
            'features' => ['iOS Development', 'Android Development', 'React Native', 'Flutter'],
        ],
        'seo-optimization' => [
            'title' => 'SEO Optimization',
            'description' => 'Improve your search engine rankings and drive organic traffic',
            'icon' => '🚀',
            'features' => ['On-Page SEO', 'Technical SEO', 'Content Strategy', 'Link Building'],
        ],
    ];

    public function index()
    {
        $seo = SeoHelper::generateMeta([
            'title' => 'Our Services | Web Development Agency',
            'description' => 'Explore our comprehensive web development, design, and digital marketing services.',
            'keywords' => 'web services, development services, design services, SEO services',
        ]);

        return view('services.index', ['seo' => $seo, 'services' => $this->services]);
    }

    public function show($slug)
    {
        if (!isset($this->services[$slug])) {
            abort(404);
        }

        $service = $this->services[$slug];
        
        $seo = SeoHelper::generateMeta([
            'title' => $service['title'] . ' | Our Services',
            'description' => $service['description'],
            'keywords' => $service['title'] . ', web development, digital services',
        ]);

        return view('services.show', compact('seo', 'service', 'slug'));
    }
}
