# Professional Web Development Agency Website

A modern, SEO-optimized Laravel 11 website built with Tailwind CSS and DaisyUI for a web development agency.

## Features

### 🎨 Modern UI
- **Tailwind CSS** for utility-first styling
- **DaisyUI** components for beautiful, accessible UI
- Fully responsive design
- Smooth animations and transitions
- Multiple theme support (light, dark, cupcake)

### 🚀 SEO Optimized
- **Meta Tags**: Complete title, description, keywords
- **Open Graph**: Facebook/LinkedIn sharing optimization
- **Twitter Cards**: Enhanced Twitter sharing
- **Schema.org Markup**: Organization, Service, WebPage, BreadcrumbList
- **XML Sitemap**: Auto-generated sitemap at `/sitemap.xml`
- **Robots.txt**: Search engine crawler configuration
- **Canonical URLs**: Prevent duplicate content issues
- **Semantic HTML**: Proper heading hierarchy (H1-H6)
- **Performance**: Optimized assets, lazy loading ready

### 📄 Pages
- **Home**: Hero section, services overview, contact form
- **Services**: Service listing with cards
- **Service Details**: Individual service pages with schema markup
- **Sitemap**: XML sitemap for search engines

### 🛠️ Technical Features
- Laravel 11 framework
- SEO Helper class for consistent meta tags
- Dynamic schema markup generation
- Service-based architecture
- Clean, maintainable code structure

## Installation

```bash
# Install PHP dependencies
composer install

# Install Node dependencies
npm install

# Copy environment file
cp .env.example .env

# Generate application key
php artisan key:generate

# Build assets
npm run build

# Start development server
php artisan serve
```

Visit: `http://localhost:8000`

## Development

```bash
# Run Vite dev server for hot reload
npm run dev

# In another terminal, run Laravel
php artisan serve
```

## Project Structure

```
app/
├── Helpers/
│   └── SeoHelper.php          # SEO meta tags and schema generation
├── Http/Controllers/
│   ├── HomeController.php     # Home page
│   ├── ServiceController.php  # Services pages
│   └── SitemapController.php  # XML sitemap

resources/views/
├── layouts/
│   └── app.blade.php          # Main layout with SEO meta tags
├── services/
│   ├── index.blade.php        # Services listing
│   └── show.blade.php         # Service detail page
├── home.blade.php             # Homepage
└── sitemap.blade.php          # XML sitemap template

public/
└── robots.txt                 # Search engine directives
```

## SEO Features Explained

### Meta Tags
Every page includes:
- Title (unique per page)
- Description (155-160 characters)
- Keywords
- Canonical URL
- Open Graph tags (og:title, og:description, og:image, og:url)
- Twitter Card tags

### Schema Markup
Structured data for:
- **Organization**: Company information, contact details, social profiles
- **Service**: Individual service descriptions
- **WebPage**: Page-level metadata
- **BreadcrumbList**: Navigation hierarchy

### Technical SEO
- Semantic HTML5 structure
- Proper heading hierarchy
- Mobile-responsive (viewport meta tag)
- Fast loading (optimized assets)
- XML sitemap for crawlers
- Robots.txt configuration

## Customization

### Update Company Info
Edit `app/Helpers/SeoHelper.php` to update default values:
- Company name
- Phone number
- Social media links
- Default images

### Add New Services
Edit `app/Http/Controllers/ServiceController.php`:
```php
private $services = [
    'your-service-slug' => [
        'title' => 'Service Name',
        'description' => 'Service description',
        'icon' => '🎯',
        'features' => ['Feature 1', 'Feature 2'],
    ],
];
```

### Change Theme
Edit `tailwind.config.js`:
```javascript
daisyui: {
    themes: ["light", "dark", "cupcake", "corporate"],
}
```

## Production Deployment

```bash
# Optimize for production
composer install --optimize-autoloader --no-dev
npm run build
php artisan config:cache
php artisan route:cache
php artisan view:cache
```

## Performance Tips

1. Enable caching in production
2. Use CDN for static assets
3. Enable Gzip compression
4. Optimize images (WebP format)
5. Implement lazy loading for images
6. Use HTTP/2
7. Enable browser caching

## SEO Checklist

✅ Unique title tags (50-60 characters)
✅ Meta descriptions (155-160 characters)
✅ Canonical URLs
✅ Schema.org markup
✅ XML sitemap
✅ Robots.txt
✅ Mobile responsive
✅ Fast loading speed
✅ Semantic HTML
✅ Alt tags for images (add when adding images)
✅ Internal linking
✅ HTTPS ready

## License

Open-source under MIT License.

## Support

For issues or questions, please open an issue on the repository.
